/**
 * @module cpixelformat_24
 * @author Manuel Mausz, 0728348
 * @brief  Implementation of CPixelFormat handling 24bit color Windows Bitmaps.
 * @date   18.04.2009
 */

#include <boost/numeric/conversion/cast.hpp>
#include "cpixelformat_24.h"

using namespace std;

void CPixelFormat_24::setPixel(const uint32_t *pixel, uint32_t x, uint32_t y)
{
  if (m_bitmap->getPixelData() == NULL)
    throw PixelFormatError("No pixelbuffer allocated.");

  uint32_t rowsize = 4 * static_cast<uint32_t>(
    ((CPixelFormat_24::getBitCount() * abs(m_bitmap->getInfoHeader().biWidth)) + 31) / 32
  );

  /* if height is positive the y-coordinates are mirrored */
  if (m_bitmap->getInfoHeader().biHeight > 0)
    y = m_bitmap->getInfoHeader().biHeight - y - 1;
  uint32_t offset = y * rowsize + x * (4 * getBitCount() / 32);

  /* boundary check */
  if (offset + 3 * sizeof(uint8_t) > m_bitmap->getInfoHeader().biSizeImage)
    throw PixelFormatError("Pixel position is out of range.");

  /* convert color values to correct types */
  uint8_t data[3];
  try
  {
    data[0] = boost::numeric_cast<uint8_t>(pixel[2]);
    data[1] = boost::numeric_cast<uint8_t>(pixel[1]);
    data[2] = boost::numeric_cast<uint8_t>(pixel[0]);
  }
  catch(boost::numeric::bad_numeric_cast& ex)
  {
    throw PixelFormatError("Unable to convert pixelcolor to correct size: " + string(ex.what()));
  }

  copy(data, data + 3, m_bitmap->getPixelData() + offset);
}

/* vim: set et sw=2 ts=2: */
