/**
 * @module cpixelformat_24
 * @author Manuel Mausz, 0728348
 * @brief  Implementation of CPixelFormat handling 24bit color Windows Bitmaps.
 * @date   18.04.2009
 */

#ifndef CPIXELFORMAT_24_H
#define CPIXELFORMAT_24_H

#include <fstream>
#include "cpixelformat.h"

/**
 * @class CPixelFormat_24
 * @brief Implementation of CPixelFormat handling 24bit color Windows Bitmaps.
 *
 * On error CPixelFormat::PixelFormatError is thrown.
 */
class CPixelFormat_24 : public CPixelFormat
{
  public:
    /**
     * @method CPixelFormat_24
     * @brief  Default ctor
     * @param  bitmap pointer to CBitmap instance
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    CPixelFormat_24(CBitmap *bitmap)
      : CPixelFormat(bitmap)
    {}

    /**
     * @method ~CPixelFormat_24
     * @brief  Default dtor
     * @param  -
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    ~CPixelFormat_24()
    {}

    /**
     * @method setPixel
     * @brief  Modifies pixel at coordinates x, y
     * @param  pixel pointer to new pixel data
     * @param  x     x-coordinate
     * @param  y     y-coordinate
     * @return -
     * @globalvars none
     * @exception  PixelFormatError
     * @conditions none
     */
    void setPixel(const uint32_t *pixel, uint32_t x, uint32_t y);

    /**
     * @method getBitCount
     * @brief  returns color bitcount supported by this class
     * @param  -
     * @return color bitcount supported by this class
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    uint32_t getBitCount()
    {
      return 24;
    }
};

#endif

/* vim: set et sw=2 ts=2: */
