/**
 * @module cpixelformat_bgr24
 * @author Guenther Neuwirth (0626638), Manuel Mausz (0728348)
 * @brief  Implementation of CPixelFormat handling 24bit color Windows Bitmaps.
 * @date   18.04.2009
 */

#ifndef CPIXELFORMAT_BGR24_H
#define CPIXELFORMAT_BGR24_H

#include <fstream>
#include "cpixelformat.h"

/**
 * @class CPixelFormat_BGR24
 * @brief Implementation of CPixelFormat handling 24bit color Windows Bitmaps.
 *
 * On error CPixelFormat::PixelFormatError is thrown.
 */
class CPixelFormat_BGR24 : public CPixelFormat
{
  public:
    /**
     * @method CPixelFormat_BGR24
     * @brief  Default ctor
     * @param  bitmap pointer to CBitmap instance
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    CPixelFormat_BGR24(CBitmap *bitmap)
      : CPixelFormat(bitmap)
    {}

    /**
     * @method ~CPixelFormat_BGR24
     * @brief  Default dtor
     * @param  -
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    ~CPixelFormat_BGR24()
    {}

    /**
     * @method getPixel
     * @brief  Get pixel at coordinates x, y
     * @param  pixel reference to pixel data
     * @param  x     x-coordinate
     * @param  y     y-coordinate
     * @return -
     * @globalvars none
     * @exception  PixelFormatError
     * @conditions none
     */
    void getPixel(RGBPIXEL& pixel, uint32_t x, uint32_t y);

    /**
     * @method setPixel
     * @brief  Modifies pixel at coordinates x, y
     * @param  pixel reference to new pixel data
     * @param  x     x-coordinate
     * @param  y     y-coordinate
     * @return -
     * @globalvars none
     * @exception  PixelFormatError
     * @conditions none
     */
    void setPixel(const RGBPIXEL& pixel, uint32_t x, uint32_t y);

    /**
     * @method getBitCount
     * @brief  returns color bitcount supported by this class
     * @param  -
     * @return color bitcount supported by this class
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    uint32_t getBitCount()
    {
      return 24;
    }

    /**
     * @method getMaxColor
     * @brief  Get maximum values for RGB pixel
     * @param  pixel reference to pixel struct
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    void getMaxColor(RGBPIXEL& pixel)
    {
      /* value = 2^8 - 1 */
      pixel.red = pixel.green = pixel.blue = 255;
    }
};

#endif

/* vim: set et sw=2 ts=2: */
