/**
 * @module cpixelformat_bgr24
 * @author Guenther Neuwirth (0626638), Manuel Mausz (0728348)
 * @brief  Implementation of CPixelFormat handling 24bit indexed bitmaps.
 * @date   02.05.2009
 */

#ifndef CPixelFormat_Indexed8_H
#define CPixelFormat_Indexed8_H

#include <fstream>
#include "cpixelformat.h"

/**
 * @class CPixelFormat_Indexed8
 * @brief Implementation of CPixelFormat handling 24bit indexed bitmaps.
 *
 * On error CPixelFormat::PixelFormatError is thrown.
 */
class CPixelFormat_Indexed8 : public CPixelFormat
{
  public:
    /**
     * @method CPixelFormat_Indexed8
     * @brief  Default ctor
     * @param  bitmap pointer to CBitmap instance
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    CPixelFormat_Indexed8(CBitmap *bitmap)
      : CPixelFormat(bitmap)
    {}

    /**
     * @method ~CPixelFormat_Indexed8
     * @brief  Default dtor
     * @param  -
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    ~CPixelFormat_Indexed8()
    {}

    /**
     * @method getPixel
     * @brief  Get pixel at coordinates x, y
     * @param  pixel reference to pixel data
     * @param  x     x-coordinate
     * @param  y     y-coordinate
     * @return -
     * @globalvars none
     * @exception  PixelFormatError
     * @conditions none
     */
    void getPixel(RGBPIXEL& pixel, uint32_t x, uint32_t y);

    /**
     * @method setPixel
     * @brief  Modifies pixel at coordinates x, y
     * @param  pixel reference to new pixel data
     * @param  x     x-coordinate
     * @param  y     y-coordinate
     * @return -
     * @globalvars none
     * @exception  PixelFormatError
     * @conditions none
     */
    void setPixel(const RGBPIXEL& pixel, uint32_t x, uint32_t y);

    /**
     * @method getBitCount
     * @brief  returns the bitcount needed for indexing the color tabel.
     * @param  -
     * @return bitcount of indexes supported by this class
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    uint32_t getBitCount()
    {
      return 24;
    }

    /**
     * @method getMaxColor
     * @brief  Get maximum values for RGB pixel
     * @param  pixel reference to pixel struct
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    void getMaxColor(RGBPIXEL& pixel)
    {
      /* value = 2^8 - 1 */
      pixel.red = pixel.green = pixel.blue = 255;
    }
};

#endif

/* vim: set et sw=2 ts=2: */
