#!/bin/bash

inputs=( $(ls test/input_* | sort -n) )

for input in ${inputs[@]}
do
  echo "Testing $input ..."

  files=()
  for tag in "#in: " "#out: " "#ref: "
  do
    tmp=$(grep "$tag" "$input")
    if [ -z "$tmp" ]
    then
      echo "  ERROR: Tag '$tag' missing"
      exit 1
    fi

    tmp=${tmp:${#tag}}
    #if [ ! -e "$tmp" ]
    #then
    #  echo "  ERROR: File '$tmp' doesn't exist"
    #  exit 1
    #fi

    files+=("$tmp")
  done

  rm -f "${files[1]}"
  ./imgsynth2 -i "$input"
  ret=$?
  if [ $ret -ne 0 ]
  then
    echo "  ERROR: Script didn't exit properly"
    exit 1
  fi

  md5_1=$(md5sum < "${files[1]}")
  md5_2=$(md5sum < "${files[2]}")
  if [ "$md5_1" != "$md5_2" ]
  then
    echo "  ERROR: ${files[1]} and ${files[2]} differ"
    exit 1
  else
    echo "  Test successful"
  fi
done

