/**
 * @module cdisplay
 * @author Guenther Neuwirth (0626638), Manuel Mausz (0728348)
 * @brief  Abstract template class for displays
 * @date   10.05.2009
 */

#ifndef CDISPLAY_H
#define CDISPLAY_H 1

/**
 * @class CDisplayT
 *
 * Abstract template class for displays
 */
template <class T>
class CDisplayT
{
  public:
    /**
     * @method CDisplayT
     * @brief  Default ctor
     * @param  name  name of display
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    CDisplayT(std::string name)
      : m_name(name)
    {}

    /**
     * @method ~CDisplayT
     * @brief  Default dtor
     * @param  -
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    virtual ~CDisplayT()
    {}

    /**
     * @method getName
     * @brief  returns name of display
     * @param  -
     * @return name of display
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    virtual const std::string& getName()
    {
      return m_name;
    }

    /**
     * @method display
     * @brief  prints value to display
     * @param  value  value to display
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    virtual void display(const T &value) = 0;

  protected:
    /* members */
    /** name of display */
    std::string m_name;
};

/**
 * @class CDisplay
 *
 * Memory definition for CCPU
 */
typedef CDisplayT<CDat> CDisplay;

#endif

/* vim: set et sw=2 ts=2: */
