/**
 * @module cinstruction
 * @author Guenther Neuwirth (0626638), Manuel Mausz (0728348)
 * @brief  Abstract class for displays
 * @date   13.05.2009
 */

#include <sstream>
#include <stdexcept>
#include <boost/lexical_cast.hpp>
#include <assert.h>
#include "cinstruction.h"
#include "ccpu.h"

using namespace std;

const unsigned CInstruction::parseRegister(const std::string& str)
{
  unsigned reg;
  if (str.length() < 2 || str[0] != 'r')
    throw runtime_error("Invalid syntax of register");

  try
  {
    reg = boost::lexical_cast<unsigned>(str.substr(1));
  }
  catch(boost::bad_lexical_cast& ex)
  {
    throw runtime_error("Invalid syntax of register");
  }

  return reg;
}

/*----------------------------------------------------------------------------*/

inline void CInstruction::checkRegister(CCPU *cpu, const unsigned regidx)
{
  assert(cpu != NULL);
  if (regidx >= cpu->getRegisterCount())
  {
    stringstream sstr;
    sstr << "Register R" << regidx << " doesn't exist (out of bound)";
    throw runtime_error(sstr.str());
  }
}

/* vim: set et sw=2 ts=2: */
