/**
 * @module cprogram
 * @author Guenther Neuwirth (0626638), Manuel Mausz (0728348)
 * @brief  CProgram extends std::vector and adds a method for parsing programfile
 * @date   10.05.2009
 */

#ifndef CPROGRAM_H
#define CPROGRAM_H 1

#include <vector>
#include <set>
#include <map>
#include "cinstruction.h"

/**
 * @class CProgram
 *
 * CProgram extends std::vector and adds a method for parsing
 * programfile. This adds instances of CInstruction to CProgram itself.
 */
class CProgram
  : public std::vector<CInstruction *>
{
  public:
    /**
     * @method CProgram
     * @brief  Default ctor
     * @param  -
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    CProgram();

    /**
     * @method ~CProgram
     * @brief  Default dtor
     * @param  -
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    ~CProgram();

    /**
     * @method getLabels
     * @brief  get reference to labels map
     * @param  -
     * @return reference to labels map
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    const std::map<std::string, unsigned>& getLabels() const
    {
      return m_labels;
    }

    /**
     * @method findLabel
     * @brief  search for label
     * @param  label  name of label to search for
     * @return index of found label in program
     * @globalvars none
     * @exception  std::runtime_error
     * @conditions none
     */
    unsigned findLabel(const std::string& label) const;

    /**
     * @method compile
     * @brief  create instructions from parsing stream
     * @param  in  inputstream to read from
     * @return void
     * @globalvars none
     * @exception  std::runtime_error
     * @conditions none
     */
    void compile(std::istream& in);

#if DEBUG
    /**
     * @method dump
     * @brief  dumps contents to outputstream
     * @param  out  outputstream to write to
     * @return void
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    void dump(std::ostream& out);
#endif

  private:
    /* members */
    /** set of known instructions */
    std::set<CInstruction *> m_instrset;
    std::map<std::string, unsigned> m_labels;
};

#endif

/* vim: set et sw=2 ts=2: */
