/**
 * @module displays
 * @author Guenther Neuwirth (0626638), Manuel Mausz (0728348)
 * @brief  Implementations of CDisplay
 * @date   10.05.2009
 */

#ifndef DISPLAYS_H
#define DISPLAYS_H 1

#include <iomanip>
#include "cdisplay.h"

/**
 * @class CDisplayWDEZ
 *
 * Implementation of CDisplay
 * Prints CDat to stdout as decimal
 */
class CDisplayWDEZ
  : public CDisplay
{
  public:
    CDisplayWDEZ()
      : CDisplay("wdez")
    {}

    /**
     * @method display
     * @brief  prints value to display
     * @param  value  value to display
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    void display(const CDat &value)
    {
      std::cout << std::dec << value << std::endl;
    }
};

/*============================================================================*/

/**
 * @class CDisplayWHEX
 *
 * Implementation of CDisplay
 * Prints CDat to stdout as decimal
 */
class CDisplayWHEX
  : public CDisplay
{
  public:
    CDisplayWHEX()
      : CDisplay("whex")
    {}

    /**
     * @method display
     * @brief  prints value to display
     * @param  value  value to display
     * @return -
     * @globalvars none
     * @exception  none
     * @conditions none
     */
    void display(const CDat &value)
    {
      std::cout << std::hex << value << std::endl;
    }
};

#endif

/* vim: set et sw=2 ts=2: */
