/*
 * Name:         global
 * Author:       Manuel Mausz, 0728348
 * Description:  Shared definitions and functions
 * Created:      24.04.2009
 */

#ifndef _GLOBAL_H
#define _GLOBAL_H 1

/*
 * IPC/shared memory stuff
 */
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sem182.h>

#define SHM_KEY ((key_t) 49583L)  /* shared memory key */
#define SHM_PERMS 0600            /* permissions */

/* shared memory structure */
#define MAX_LEN 512 /* maximal log message length */
typedef struct
{
  char msg[MAX_LEN];
} shm_t;

/*
 * Semaphore stuff
 */
#define SEM_KEY1 ((key_t) 49584L) /* semaphore key 1 */
#define SEM_KEY2 ((key_t) 49585L) /* semaphore key 2 */
#define SEM_PERMS 0600

/*
 * Signal stuff
 */
#include <signal.h>

/* install signal handler macro */
#define INSTALL_SIGNAL(signum, act, oldact) \
  sigaction(signum, NULL, &oldact); \
  if (oldact.sa_handler != SIG_IGN) \
    sigaction(signum, &act, NULL);

/*
 * global.c stuff
 */
#include <stdarg.h>

/* function declarations */
void vprintferr(const char *fmt, va_list ap);
void printferr(const char *fmt, ...);
void bailout(const char *fmt, ...);

/* global variable definitions */
/* libc manual: Handlers that return normally must modify some global variable
 * in order to have any effect. Typically, the variable is one that is examined
 * periodically by the program during normal operation. Its data type should be
 * sig_atomic_t for reasons described in Atomic Data Access.
 */
extern volatile sig_atomic_t error;  /* error flag */
extern char *me;                     /* name of myself (argv[0]) */

#endif /* global.h */
